<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Contact $contact
 */
?>
<head>
    <?php echo $this->Html->css('contact_us.css'); ?>
</head>
<div class="top-part">
    <div class="top-text">
        <h1 class="title">Stay in Touch with us</h1>
        <p class="subtitle">
            <i>We’d love to keep you updated with our latest creations, seasonal flavors, and special offers. Join our community of cheese and curd lovers by following us on social media or signing up for our Cheese Lovers Club. Stay connected, stay cultured!</i>
        </p>
    </div>
    <?php echo $this->Html->image("cows.png", ['class' => 'background-img']) ?>

</div>
<div class="row" style="padding-bottom: 100px">
    <div class="column column-50" style="padding-top: 20px;">
        <h2><b>Contact Us</b></h2>
        <br><p><b>Phone</b> - (+61)12 3456 7890</p>
        <p><b>Email</b> - info@curdandculture.com</p>
        <b>Location</b> - 1234 Dairy Avenue, Dandenong, Victoria:3175</p>
    </div>
    <div class="column column-50" style="padding-top: 20px;">
        <h2><b>Got an inquiry? Let us know</b></h2>
        <div class="contacts form content">
            <?= $this->Form->create($contact) ?>
            <fieldset>
                <!--<legend><?= __('Contact Us') ?></legend>-->
                <?php
                    echo $this->Form->control('name',['placeholder'=>'Name']);
                    echo $this->Form->control('email',['placeholder'=>'Email']);
                    echo $this->Form->control('message', ['type' => 'textarea', 'placeholder' => 'Type your message']);
                ?>
            </fieldset>
            <div class="cf-turnstile" data-sitekey="0x4AAAAAABt5hZgpXOav-wp7" data-size="flexible" theme="light"></div>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
<script
  src="https://challenges.cloudflare.com/turnstile/v0/api.js"
  async
  defer
></script>
